<?php
require_once __DIR__ . '/includes/config.php';

if (!isset($_GET['order_id'])) {
    header("Location: index.php");
    exit();
}

$order_id = intval($_GET['order_id']);

// Get order details
$order_sql = "SELECT o.*, c.name as customer_name 
              FROM orders o
              JOIN customers c ON o.customer_id = c.customer_id
              WHERE o.order_id = ?";
$stmt = $conn->prepare($order_sql);
$stmt->bind_param("i", $order_id);
$stmt->execute();
$order_result = $stmt->get_result();
$order = $order_result->fetch_assoc();

if (!$order) {
    header("Location: index.php");
    exit();
}

$pageTitle = 'Thank You';
require_once __DIR__ . '/includes/header.php';
?>

<main class="thank-you-page">
    <div class="container">
        <div class="thank-you-content">
            <i class="fas fa-check-circle"></i>
            <h1>Thank You for Your Order!</h1>
            <p>Your order has been received and is being processed. We'll contact you shortly to confirm the details.</p>
            
            <div class="order-details">
                <h3>Order Details</h3>
                <div class="detail-row">
                    <span>Order Number:</span>
                    <span>#<?php echo $order['order_id']; ?></span>
                </div>
                <div class="detail-row">
                    <span>Date:</span>
                    <span><?php echo date('F j, Y', strtotime($order['order_date'])); ?></span>
                </div>
                <div class="detail-row">
                    <span>Total:</span>
                    <span>KShs <?php echo number_format($order['total_amount'], 2); ?></span>
                </div>
                <div class="detail-row">
                    <span>Payment Method:</span>
                    <span>Cash on Delivery</span>
                </div>
            </div>
            
            <a href="shop.php" class="btn">Continue Shopping</a>
        </div>
    </div>
</main>

<?php
require_once __DIR__ . '/includes/footer.php';
?>