<?php
require_once __DIR__ . '/includes/config.php';

if (!isset($_GET['id'])) {
    header("Location: blog.php");
    exit();
}

$post_id = intval($_GET['id']);

// Get blog post
$sql = "SELECT * FROM blog_posts WHERE post_id = ? AND is_published = 1";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $post_id);
$stmt->execute();
$result = $stmt->get_result();
$post = $result->fetch_assoc();

if (!$post) {
    header("Location: blog.php");
    exit();
}

$pageTitle = $post['title'];
require_once __DIR__ . '/includes/header.php';
?>

<main class="single-post-page">
    <div class="container">
        <article class="blog-post">
            <div class="post-header">
                <h1><?php echo htmlspecialchars($post['title']); ?></h1>
                <div class="post-meta">
                    <span class="post-date"><?php echo date('F j, Y', strtotime($post['published_at'])); ?></span>
                </div>
            </div>
            
            <div class="post-image">
                <img src="<?php echo BASE_URL; ?>/images/blog/<?php echo htmlspecialchars($post['featured_image']); ?>" alt="<?php echo htmlspecialchars($post['title']); ?>">
            </div>
            
            <div class="post-content">
                <?php echo $post['content']; ?>
            </div>
        </article>
        
        <div class="post-navigation">
            <a href="blog.php" class="btn">Back to Blog</a>
        </div>
    </div>
</main>

<?php
require_once __DIR__ . '/includes/footer.php';
?>