<?php
require_once __DIR__ . '/includes/config.php';

if (!isset($_GET['id'])) {
    header("Location: shop.php");
    exit();
}

$product_id = intval($_GET['id']);

// Get product details
$product_sql = "SELECT p.*, c.name as category_name 
               FROM products p 
               LEFT JOIN categories c ON p.category_id = c.category_id
               WHERE p.product_id = ?";
$stmt = $conn->prepare($product_sql);
$stmt->bind_param("i", $product_id);
$stmt->execute();
$product_result = $stmt->get_result();
$product = $product_result->fetch_assoc();

if (!$product) {
    header("Location: shop.php");
    exit();
}

// Get product variants
$variant_sql = "SELECT * FROM product_variants WHERE product_id = ?";
$stmt = $conn->prepare($variant_sql);
$stmt->bind_param("i", $product_id);
$stmt->execute();
$variant_result = $stmt->get_result();
$variants = $variant_result->fetch_all(MYSQLI_ASSOC);

$pageTitle = $product['name'];
require_once __DIR__ . '/includes/header.php';
?>

<main class="product-page">
    <div class="container">
        <div class="product-detail">
            <div class="product-images">
                <img src="<?php echo BASE_URL; ?>/images/products/<?php echo htmlspecialchars($product['image_url']); ?>" alt="<?php echo htmlspecialchars($product['name']); ?>">
            </div>
            
            <div class="product-info">
                <h1><?php echo htmlspecialchars($product['name']); ?></h1>
                <p class="category"><?php echo htmlspecialchars($product['category_name']); ?></p>
                
                <?php if (count($variants) > 0): ?>
                    <form class="product-form" action="add_to_cart.php" method="post">
                        <input type="hidden" name="product_id" value="<?php echo $product['product_id']; ?>">
                        
                        <div class="form-group">
                            <label for="variant">Select Option:</label>
                            <select name="variant_id" id="variant" required>
                                <?php foreach ($variants as $variant): ?>
                                    <option value="<?php echo $variant['variant_id']; ?>" 
                                            data-price="<?php echo $variant['price']; ?>">
                                        <?php echo htmlspecialchars($variant['variant_name']); ?> - KShs <?php echo number_format($variant['price'], 2); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label for="quantity">Quantity:</label>
                            <input type="number" name="quantity" id="quantity" min="1" value="1" required>
                        </div>
                        
                        <div class="price-section">
                            <span class="price">KShs <span id="display-price"><?php echo number_format($variants[0]['price'], 2); ?></span></span>
                        </div>
                        
                        <button type="submit" class="btn btn-large">Add to Cart</button>
                    </form>
                <?php else: ?>
                    <div class="price-section">
                        <span class="price">KShs <?php echo number_format($product['base_price'], 2); ?></span>
                    </div>
                    <form class="product-form" action="add_to_cart.php" method="post">
                        <input type="hidden" name="product_id" value="<?php echo $product['product_id']; ?>">
                        <div class="form-group">
                            <label for="quantity">Quantity:</label>
                            <input type="number" name="quantity" id="quantity" min="1" value="1" required>
                        </div>
                        <button type="submit" class="btn btn-large">Add to Cart</button>
                    </form>
                <?php endif; ?>
                
                <div class="product-description">
                    <h3>Description</h3>
                    <p><?php echo htmlspecialchars($product['description']); ?></p>
                </div>
            </div>
        </div>
    </div>
</main>

<script>
    // Update displayed price when variant changes
    document.getElementById('variant').addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex];
        const price = selectedOption.getAttribute('data-price');
        document.getElementById('display-price').textContent = parseFloat(price).toFixed(2);
    });
</script>

<?php
require_once __DIR__ . '/includes/footer.php';
?>