<?php
require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/header.php';

$quoteSubmitted = false;
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Sanitize input data
    $name = $conn->real_escape_string(trim($_POST['name']));
    $email = $conn->real_escape_string(trim($_POST['email']));
    $phone = $conn->real_escape_string(trim($_POST['phone']));
    $product_interest = intval($_POST['product_interest']);
    $project_details = $conn->real_escape_string(trim($_POST['project_details']));
    
    // Validate inputs
    if (empty($name) || empty($email) || empty($phone) || empty($project_details) || $product_interest <= 0) {
        $error = 'Please fill all required fields.';
    } else {
        // Insert into database
        $sql = "INSERT INTO quotes (name, email, phone, product_id, project_details, date_submitted) 
                VALUES ('$name', '$email', '$phone', $product_interest, '$project_details', NOW())";
        
        if ($conn->query($sql)) {
            $quoteSubmitted = true;
            
            // Send email notification
            $to = 'quotes@reliablemabati.com';
            $subject = 'New Quote Request from ' . $name;
            $message = "You have received a new quote request:\n\n";
            $message .= "Name: $name\n";
            $message .= "Email: $email\n";
            $message .= "Phone: $phone\n";
            $message .= "Product Interest ID: $product_interest\n";
            $message .= "Project Details:\n$project_details\n";
            
            $headers = "From: $email";
            
            mail($to, $subject, $message, $headers);
        } else {
            $error = 'There was an error submitting your quote. Please try again.';
        }
    }
}
?>

<main>
    <section class="quote-result">
        <div class="container">
            <?php if ($quoteSubmitted): ?>
                <div class="success-message">
                    <h2>Thank You for Your Quote Request!</h2>
                    <p>We've received your request and will get back to you within 24 hours with a customized quote.</p>
                    <p>In the meantime, feel free to browse our <a href="<?php echo BASE_URL; ?>/shop.php">product catalog</a> or contact us directly if you have urgent inquiries.</p>
                    <a href="<?php echo BASE_URL; ?>" class="btn">Back to Home</a>
                </div>
            <?php elseif (!empty($error)): ?>
                <div class="error-message">
                    <h2>Error Processing Your Request</h2>
                    <p><?php echo htmlspecialchars($error); ?></p>
                    <a href="javascript:history.back()" class="btn">Go Back</a>
                </div>
            <?php else: ?>
                <div class="error-message">
                    <h2>Invalid Request</h2>
                    <p>Please submit the quote form to access this page.</p>
                    <a href="<?php echo BASE_URL; ?>" class="btn">Back to Home</a>
                </div>
            <?php endif; ?>
        </div>
    </section>
</main>

<?php
require_once __DIR__ . '/includes/footer.php';
?>