<?php
$pageTitle = 'Home';
require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/header.php';
?>

<main>
    <section class="hero" style="background-image: url('<?php echo BASE_URL; ?>/images/roofing-bg.png'); background-size: cover; background-position: center; background-repeat: no-repeat; padding: 100px 0; color: white; text-align: center;">
        <div class="container">
            <h1>Quality Roofing Products for Your Home</h1>
            <p>Durable, affordable, and stylish roofing solutions across Kenya</p>
            <a href="<?php echo BASE_URL; ?>/shop.php" class="btn btn-large">Shop Now</a>
        </div>
    </section>

    <section class="featured-products">
        <div class="container">
            <h2>Our Popular Products</h2>
            <div class="product-grid">
                <?php
                // Get featured products
                $sql = "SELECT * FROM products WHERE is_featured = 1 LIMIT 6";
                $result = $conn->query($sql);
                
                if ($result->num_rows > 0) {
                    while($row = $result->fetch_assoc()) {
                        echo '<div class="product-card">';
                        echo '  <div class="product-image">';
                        echo '    <img src="' . BASE_URL . '/images/products/' . htmlspecialchars($row['image_url']) . '" alt="' . htmlspecialchars($row['name']) . '">';
                        echo '  </div>';
                        echo '  <div class="product-details">';
                        echo '    <h3>' . htmlspecialchars($row['name']) . '</h3>';
                        echo '    <p class="price">From KShs ' . number_format($row['base_price'], 2) . '</p>';
                        echo '    <a href="' . BASE_URL . '/product.php?id=' . $row['product_id'] . '" class="btn">View Details</a>';
                        echo '  </div>';
                        echo '</div>';
                    }
                } else {
                    echo '<p>No featured products found.</p>';
                }
                ?>
            </div>
        </div>
    </section>

    <section class="guarantees">
        <div class="container">
            <div class="guarantee-item">
                <i class="fas fa-truck"></i>
                <h3>Free Delivery</h3>
                <p>Across Kenya for all orders</p>
            </div>
            <div class="guarantee-item">
                <i class="fas fa-certificate"></i>
                <h3>Certified Quality</h3>
                <p>100% Guarantee</p>
            </div>
            <div class="guarantee-item">
                <i class="fas fa-piggy-bank"></i>
                <h3>Huge Savings</h3>
                <p>At Lowest Price</p>
            </div>
            <div class="guarantee-item">
                <i class="fas fa-exchange-alt"></i>
                <h3>Easy Returns</h3>
                <p>No Questions Asked</p>
            </div>
        </div>
    </section>

    <section class="testimonials">
        <div class="container">
            <h2>What Our Customers Say</h2>
            <div class="testimonial-slider">
                <?php
                // Get approved testimonials
                $sql = "SELECT * FROM testimonials WHERE is_approved = 1 ORDER BY date_posted DESC LIMIT 3";
                $result = $conn->query($sql);
                
                if ($result->num_rows > 0) {
                    while($row = $result->fetch_assoc()) {
                        echo '<div class="testimonial">';
                        echo '  <div class="testimonial-content">' . htmlspecialchars($row['content']) . '</div>';
                        echo '  <div class="testimonial-author">' . htmlspecialchars($row['customer_name']) . '</div>';
                        echo '  <div class="testimonial-rating">';
                        for ($i = 1; $i <= 5; $i++) {
                            echo $i <= $row['rating'] ? '<i class="fas fa-star"></i>' : '<i class="far fa-star"></i>';
                        }
                        echo '  </div>';
                        echo '</div>';
                    }
                } else {
                    echo '<p>No testimonials yet.</p>';
                }
                ?>
            </div>
        </div>
    </section>

    <section id="quote-section" class="free-quote">
        <section class="free-quote">
            <div class="container">
                <div class="quote-container">
                    <div class="quote-form">
                        <h2>Get A Free Quote</h2>
                        <p>Fill out the form below and we'll get back to you with a customized quote for your roofing needs</p>
                        
                        <form action="<?php echo BASE_URL; ?>/process_quote.php" method="POST">
                            <div class="form-group">
                                <input type="text" name="name" placeholder="Your Name" required>
                            </div>
                            <div class="form-group">
                                <input type="email" name="email" placeholder="Email Address" required>
                            </div>
                            <div class="form-group">
                                <input type="tel" name="phone" placeholder="Phone Number" required>
                            </div>
                            <div class="form-group">
                                <select name="product_interest" required>
                                    <option value="">Select Product of Interest</option>
                                    <?php
                                    $sql = "SELECT product_id, name FROM products WHERE is_active = 1 ORDER BY name";
                                    $result = $conn->query($sql);
                                    
                                    if ($result->num_rows > 0) {
                                        while($row = $result->fetch_assoc()) {
                                            echo '<option value="' . $row['product_id'] . '">' . htmlspecialchars($row['name']) . '</option>';
                                        }
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <textarea name="project_details" placeholder="Tell us about your project (size, location, special requirements)" rows="4" required></textarea>
                            </div>
                            <div class="form-group">
                                <button type="submit" class="btn btn-large">Request Free Quote</button>
                            </div>
                        </form>
                    </div>
                    <div class="quote-benefits">
                        <h3>Why Get a Quote From Us?</h3>
                        <ul>
                            <li><i class="fas fa-check-circle"></i> No obligation, free estimates</li>
                            <li><i class="fas fa-check-circle"></i> Competitive pricing</li>
                            <li><i class="fas fa-check-circle"></i> Expert advice on materials</li>
                            <li><i class="fas fa-check-circle"></i> Customized solutions</li>
                            <li><i class="fas fa-check-circle"></i> Quick response time</li>
                        </ul>
                        <div class="quote-contact">
                            <h4>Prefer to talk directly?</h4>
                            <p><i class="fas fa-phone"></i> Call us: <a href="tel:+254700000000">+254 743 481729</a></p>
                            <p><i class="fas fa-envelope"></i> Email: <a href="mailto:quotes@reliablemabati.com">quotes@reliablemabati.com</a></p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </section>    
</main>

<?php
require_once __DIR__ . '/includes/footer.php';
?>