<?php
require_once __DIR__ . '/../includes/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? $pageTitle . ' - ' : ''; ?><?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* Smooth scrolling for anchor links */
        html {
            scroll-behavior: smooth;
        }
        
        /* Highlight for quote section when navigated to */
        #quote-section:target {
            animation: highlight 2s ease;
        }
        
        @keyframes highlight {
            0% { background-color: rgba(255, 255, 0, 0.1); }
            100% { background-color: rgba(255, 255, 0, 0); }
        }
        
        /* New styles for centered logo */
        .logo-container {
            display: flex;
            justify-content: center;
            padding: 20px 0;
            background-color: #fff;
            border-bottom: 1px solid #eee;
        }
        
        .logo-center {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .logo-center img {
            height: 80px;
        }
        
        .logo-center span {
            font-size: 1.8rem;
            font-weight: bold;
            color: #333;
        }

        /* Mobile Menu Styles */
        .overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 999;
            opacity: 0;
            pointer-events: none;
            transition: opacity 0.3s ease-in-out;
        }

        .overlay.active {
            opacity: 1;
            pointer-events: auto;
        }

        @media (max-width: 768px) {
            .nav-links {
                position: fixed;
                top: 0;
                left: -100%;
                width: 80%;
                max-width: 300px;
                height: 100vh;
                background-color: white;
                flex-direction: column;
                padding: 3rem 1.5rem;
                box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
                transition: left 0.3s ease-in-out;
                z-index: 1000;
                display: flex;
            }
            
            .nav-links.active {
                left: 0;
            }
            
            .nav-links li {
                margin: 0.5rem 0;
            }
            
            .mobile-menu-btn {
                display: block;
                z-index: 1001;
                font-size: 1.5rem;
                cursor: pointer;
                color: #2c5282;
            }

            .mobile-menu-btn.active i::before {
                content: '\f00d';
            }
        }
    </style>
</head>
<body>
    <header>
        <!-- Centered Logo Section -->
        <div class="logo-container">
            <div class="logo-center">
                <a href="<?php echo BASE_URL; ?>" style="display: flex; align-items: center; text-decoration: none;">
                    <img src="<?php echo BASE_URL; ?>/images/logo.jpeg" alt="Reliable Mabati Logo">
                    <span>Reliable Mabati</span>
                </a>
            </div>
        </div>
        
        <div class="top-bar">
            <div class="container">
                <div class="contact-info">
                    <span><i class="fas fa-envelope"></i> sales@reliablemabati.co.ke</span>
                    <span><i class="fas fa-phone"></i> +254 743 481 729</span>
                </div>
                <div class="cta-button">
                    <a href="<?php echo BASE_URL; ?>/#quote-section" class="btn">Get A Free Quote</a>
                </div>
            </div>
        </div>
        
        <nav class="main-nav">
            <div class="container">
                <ul class="nav-links">
                    <li><a href="<?php echo BASE_URL; ?>" <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'class="active"' : ''; ?>>Home</a></li>
                    <li><a href="<?php echo BASE_URL; ?>/shop.php" <?php echo basename($_SERVER['PHP_SELF']) == 'shop.php' ? 'class="active"' : ''; ?>>Shop</a></li>
                    <li><a href="<?php echo BASE_URL; ?>/about.php" <?php echo basename($_SERVER['PHP_SELF']) == 'about.php' ? 'class="active"' : ''; ?>>About</a></li>
                    <li><a href="<?php echo BASE_URL; ?>/contact.php" <?php echo basename($_SERVER['PHP_SELF']) == 'contact.php' ? 'class="active"' : ''; ?>>Contact</a></li>
                    <li><a href="<?php echo BASE_URL; ?>/blog.php" <?php echo basename($_SERVER['PHP_SELF']) == 'blog.php' ? 'class="active"' : ''; ?>>Blog</a></li>
                    <li><a href="<?php echo BASE_URL; ?>/cart.php"><i class="fas fa-shopping-cart"></i> <span class="cart-count"><?php echo isset($_SESSION['cart']) ? count($_SESSION['cart']) : 0; ?></span></a></li>
                </ul>
                <div class="mobile-menu-btn">
                    <i class="fas fa-bars"></i>
                </div>
            </div>
        </nav>
        <div class="overlay"></div>
    </header>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const mobileMenuBtn = document.querySelector('.mobile-menu-btn');
            const navLinks = document.querySelector('.nav-links');
            const overlay = document.querySelector('.overlay');
            const navItems = document.querySelectorAll('.nav-links a');

            // Toggle mobile menu
            mobileMenuBtn.addEventListener('click', function() {
                navLinks.classList.toggle('active');
                overlay.classList.toggle('active');
                mobileMenuBtn.classList.toggle('active');
            });

            // Close menu when clicking overlay
            overlay.addEventListener('click', function() {
                navLinks.classList.remove('active');
                overlay.classList.remove('active');
                mobileMenuBtn.classList.remove('active');
            });

            // Close menu when clicking a link
            navItems.forEach(item => {
                item.addEventListener('click', function() {
                    navLinks.classList.remove('active');
                    overlay.classList.remove('active');
                    mobileMenuBtn.classList.remove('active');
                });
            });
        });
    </script>