<?php
require_once __DIR__ . '/includes/config.php';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name    = trim($_POST['name']);
    $email   = trim($_POST['email']);
    $phone   = trim($_POST['phone']);
    $subject = trim($_POST['subject']);
    $message = trim($_POST['message']);

    $errors = [];
    if (empty($name)) $errors[] = 'Name is required.';
    if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = 'Valid email is required.';
    if (empty($message)) $errors[] = 'Message is required.';

    if (empty($errors)) {
        $to = 'sales@reliablemabati.co.ke';
        $headers = "From: $email\r\nReply-To: $email\r\n";
        $email_content = "Name: $name\nEmail: $email\nPhone: $phone\nSubject: $subject\n\nMessage:\n$message";

        // mail($to, $subject, $email_content, $headers); // Uncomment when ready
        $success = true;
    }
}

$pageTitle = 'Contact Us';
require_once __DIR__ . '/includes/header.php';
?>

<main class="contact-page">
    <div class="container">
        <h1 class="section-title">Get in Touch with Reliable Mabati</h1>
        <p class="section-subtitle">We’re here to help. Reach out for inquiries, quotes, or support.</p>

        <div class="contact-grid">
            <!-- Contact Form -->
            <div class="contact-form">
                <h2>Send a Message</h2>

                <?php if (!empty($success)): ?>
                    <div class="alert alert-success">✅ Thank you! We'll respond shortly.</div>
                <?php elseif (!empty($errors)): ?>
                    <div class="alert alert-error">
                        <?php foreach ($errors as $error): ?>
                            <p>❌ <?php echo htmlspecialchars($error); ?></p>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>

                <form action="contact.php" method="post">
                    <div class="form-group">
                        <label for="name">Name*</label>
                        <input type="text" id="name" name="name" required value="<?= htmlspecialchars($name ?? '') ?>">
                    </div>

                    <div class="form-group">
                        <label for="email">Email*</label>
                        <input type="email" id="email" name="email" required value="<?= htmlspecialchars($email ?? '') ?>">
                    </div>

                    <div class="form-group">
                        <label for="phone">Phone</label>
                        <input type="tel" id="phone" name="phone" value="<?= htmlspecialchars($phone ?? '') ?>">
                    </div>

                    <div class="form-group">
                        <label for="subject">Subject</label>
                        <input type="text" id="subject" name="subject" value="<?= htmlspecialchars($subject ?? '') ?>">
                    </div>

                    <div class="form-group">
                        <label for="message">Message*</label>
                        <textarea id="message" name="message" rows="5" required><?= htmlspecialchars($message ?? '') ?></textarea>
                    </div>

                    <button type="submit" class="btn btn-primary">📩 Send Message</button>
                </form>
            </div>

            <!-- Contact Info -->
            <div class="contact-info">
                <h2>Contact Information</h2>
                <div class="info-item">
                    <i class="fas fa-map-marker-alt"></i>
                    <div>
                        <h4>Office Location</h4>
                        <p>Industrial Area, Nairobi, Kenya</p>
                    </div>
                </div>

                <div class="info-item">
                    <i class="fas fa-phone-alt"></i>
                    <div>
                        <h4>Phone</h4>
                        <p>+254 743 481729</p>
                    </div>
                </div>

                <div class="info-item">
                    <i class="fas fa-envelope"></i>
                    <div>
                        <h4>Email</h4>
                        <p>sales@reliablemabati.co.ke</p>
                    </div>
                </div>

                <div class="info-item">
                    <i class="fas fa-clock"></i>
                    <div>
                        <h4>Business Hours</h4>
                        <p>Mon–Fri: 8:00 AM – 5:00 PM</p>
                        <p>Saturday: 9:00 AM – 2:00 PM</p>
                        <p>Sunday: Closed</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Google Map Section -->
        <div class="map-section">
            <h2>Our Location</h2>
            <iframe 
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d15955.402226274758!2d36.837457!3d-1.2973279!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x182f10f7c3e42f3d%3A0x12e44d25a9b5d132!2sIndustrial%20Area%2C%20Nairobi!5e0!3m2!1sen!2ske!4v1620212920220!5m2!1sen!2ske"
                width="100%" height="400" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
        </div>
    </div>
</main>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
