<?php
require_once __DIR__ . '/includes/config.php';

// Get blog posts
$sql = "SELECT * FROM blog_posts WHERE is_published = 1 ORDER BY published_at DESC";
$result = $conn->query($sql);

$pageTitle = 'Blog';
require_once __DIR__ . '/includes/header.php';
?>

<main class="blog-page">
    <div class="container">
        <h1>Our Blog</h1>
        
        <div class="blog-grid">
            <?php if ($result->num_rows > 0): ?>
                <?php while($post = $result->fetch_assoc()): ?>
                    <article class="blog-post">
                        <div class="post-image">
                            <img src="<?php echo BASE_URL; ?>/images/blog/<?php echo htmlspecialchars($post['featured_image']); ?>" alt="<?php echo htmlspecialchars($post['title']); ?>">
                        </div>
                        <div class="post-content">
                            <h2><a href="single_post.php?id=<?php echo $post['post_id']; ?>"><?php echo htmlspecialchars($post['title']); ?></a></h2>
                            <div class="post-meta">
                                <span class="post-date"><?php echo date('F j, Y', strtotime($post['published_at'])); ?></span>
                            </div>
                            <p class="post-excerpt"><?php echo htmlspecialchars($post['excerpt']); ?></p>
                            <a href="single_post.php?id=<?php echo $post['post_id']; ?>" class="read-more">Read More</a>
                        </div>
                    </article>
                <?php endwhile; ?>
            <?php else: ?>
                <p>No blog posts found.</p>
            <?php endif; ?>
        </div>
    </div>
</main>

<?php
require_once __DIR__ . '/includes/footer.php';
?>