<?php
require_once '../includes/config.php';
require_once __DIR__ . '/includes/admin_auth.php';
require_once __DIR__ . '/includes/admin_header.php';

// Get current user data
$stmt = $conn->prepare("
    SELECT u.*, r.name AS role_name 
    FROM admin_users u
    JOIN admin_roles r ON u.role_id = r.id
    WHERE u.id = ?
");
$stmt->bind_param("i", $_SESSION['admin_id']);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

require_once __DIR__ . '/includes/admin_header.php';
?>

<div class="admin-content">
    <div class="page-header">
        <h1 class="page-title">My Profile</h1>
    </div>

    <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            <?= htmlspecialchars($_SESSION['success']) ?>
        </div>
        <?php unset($_SESSION['success']); ?>
    <?php endif; ?>

    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-error">
            <i class="fas fa-exclamation-circle"></i>
            <?= htmlspecialchars($_SESSION['error']) ?>
        </div>
        <?php unset($_SESSION['error']); ?>
    <?php endif; ?>

    <div class="form-grid">
        <div class="form-container">
            <h3>Profile Information</h3>
            <form action="profile_save.php" method="post">
                <div class="form-group">
                    <label>Username</label>
                    <p class="form-control-static"><?= htmlspecialchars($user['username']) ?></p>
                </div>
                <div class="form-group">
                    <label for="email">Email</label>
                    <input type="email" id="email" name="email" class="form-control"
                           value="<?= htmlspecialchars($user['email']) ?>" required>
                </div>
                <div class="form-group">
                    <label for="full_name">Full Name</label>
                    <input type="text" id="full_name" name="full_name" class="form-control"
                           value="<?= htmlspecialchars($user['full_name']) ?>" required>
                </div>
                <div class="form-group">
                    <label>Role</label>
                    <p class="form-control-static"><?= htmlspecialchars($user['role_name']) ?></p>
                </div>
                <div class="form-group">
                    <label>Last Login</label>
                    <p class="form-control-static">
                        <?= $user['last_login'] ? date('M j, Y g:i a', strtotime($user['last_login'])) : 'Never' ?>
                    </p>
                </div>
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>

        <div class="form-container">
            <h3>Change Password</h3>
            <form action="password_change.php" method="post">
                <div class="form-group">
                    <label for="current_password">Current Password</label>
                    <input type="password" id="current_password" name="current_password" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="new_password">New Password</label>
                    <input type="password" id="new_password" name="new_password" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="confirm_password">Confirm New Password</label>
                    <input type="password" id="confirm_password" name="confirm_password" class="form-control" required>
                </div>
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">Change Password</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/includes/admin_footer.php'; ?>
