<?php
require_once __DIR__ . '/includes/admin_header.php';
require_once __DIR__ . '/includes/config.php'; 

// Get all products using MySQLi
$query = "
    SELECT p.*, c.name as category_name 
    FROM products p
    LEFT JOIN categories c ON p.category_id = c.category_id
    ORDER BY p.created_at DESC
";
$result = $conn->query($query);

$products = [];
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $products[] = $row;
    }
}
?>

<div class="admin-content">
    <div class="page-header">
        <h1 class="page-title">Products</h1>
        <div class="page-actions">
            <a href="product_add.php" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add Product
            </a>
        </div>
    </div>

    <?php if (isset($_GET['success'])): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            Product has been <?= htmlspecialchars($_GET['success']) ?> successfully!
        </div>
    <?php endif; ?>

    <div class="data-table-container">
        <div class="table-header">
            <h3 class="table-title">All Products</h3>
            <div class="table-actions">
                <div class="search-box">
                    <i class="fas fa-search"></i>
                    <input type="text" placeholder="Search products...">
                </div>
                <select class="form-control">
                    <option>All Categories</option>
                    <option>Box Profile</option>
                    <option>Brick Tile</option>
                    <option>Corrugated</option>
                </select>
            </div>
        </div>

        <table class="data-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Product</th>
                    <th>Category</th>
                    <th>Price</th>
                    <th>Stock</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($products as $product): ?>
                    <tr>
                        <td><?= $product['product_id'] ?></td>
                        <td>
                            <div class="user-cell">
                                <img src="../images/products/<?= htmlspecialchars($product['image_url']) ?>" alt="<?= htmlspecialchars($product['name']) ?>">
                                <span><?= htmlspecialchars($product['name']) ?></span>
                            </div>
                        </td>
                        <td><?= htmlspecialchars($product['category_name'] ?? 'Uncategorized') ?></td>
                        <td>KSh <?= number_format($product['base_price'], 2) ?></td>
                        <td><?= $product['stock'] ?></td>
                        <td>
                            <span class="status-badge <?= $product['is_active'] ? 'completed' : 'cancelled' ?>">
                                <?= $product['is_active'] ? 'Active' : 'Inactive' ?>
                            </span>
                        </td>
                        <td class="action-cell">
                            <a href="product_view.php?id=<?= $product['product_id'] ?>" class="action-btn" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="product_edit.php?id=<?= $product['product_id'] ?>" class="action-btn" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <button class="action-btn delete" title="Delete" onclick="confirmDelete(<?= $product['product_id'] ?>)">
                                    <i class="fas fa-trash"></i>
                                </button>

                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <div class="table-footer">
            <div class="table-info">
                Showing <?= count($products) ?> entries
            </div>
            <div class="pagination">
                <button class="pagination-btn" disabled><i class="fas fa-chevron-left"></i></button>
                <button class="pagination-btn active">1</button>
                <button class="pagination-btn">2</button>
                <button class="pagination-btn">3</button>
                <button class="pagination-btn"><i class="fas fa-chevron-right"></i></button>
            </div>
        </div>
    </div>
</div>

<div class="modal-overlay" id="deleteModal">
    <div class="modal">
        <div class="modal-header">
            <h3 class="modal-title">Confirm Delete</h3>
            <button class="modal-close" onclick="closeModal()">&times;</button>
        </div>
        <div class="modal-body">
            <p>Are you sure you want to delete this product? This action cannot be undone.</p>
        </div>
        <div class="modal-footer">
            <button class="btn" onclick="closeModal()">Cancel</button>
            <button class="btn btn-danger" id="confirmDeleteBtn">Delete</button>
        </div>
    </div>
</div>

<script>
let productIdToDelete = null;

function confirmDelete(id) {
    productIdToDelete = id;
    document.getElementById('deleteModal').classList.add('active');
}

function closeModal() {
    document.getElementById('deleteModal').classList.remove('active');
}

document.getElementById('confirmDeleteBtn').addEventListener('click', function () {
    if (productIdToDelete) {
        window.location.href = 'product_delete.php?id=' + productIdToDelete;
    }
});
</script>

<?php require_once __DIR__ . '/includes/admin_footer.php'; ?>
