<?php
require_once __DIR__ . '/includes/admin_header.php';

// Fetch categories for dropdown
$categories = [];
$catResult = $conn->query("SELECT category_id, name FROM categories ORDER BY name ASC");
while ($row = $catResult->fetch_assoc()) {
    $categories[] = $row;
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $conn->real_escape_string($_POST['name']);
    $category_id = (int)$_POST['category_id'];
    $base_price = (float)$_POST['base_price'];
    $stock = (int)$_POST['stock'];
    $description = $conn->real_escape_string($_POST['description']);
    $is_active = isset($_POST['is_active']) ? 1 : 0;

    // Handle image upload
    $image_name = '';
    if (!empty($_FILES['image']['name'])) {
        $target_dir = "../images/products/";
        $image_name = time() . '_' . basename($_FILES['image']['name']);
        $target_file = $target_dir . $image_name;
        move_uploaded_file($_FILES['image']['tmp_name'], $target_file);
    }

    // Insert into DB
    $stmt = $conn->prepare("INSERT INTO products (name, category_id, base_price, stock, image_url, description, is_active) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("siddssi", $name, $category_id, $base_price, $stock, $image_name, $description, $is_active);
    if ($stmt->execute()) {
        header("Location: products.php?success=added");
        exit;
    } else {
        $error = "Failed to add product: " . $conn->error;
    }
}
?>

<div class="admin-content">
    <div class="page-header">
        <h1 class="page-title">Add New Product</h1>
    </div>

    <?php if (!empty($error)): ?>
        <div class="alert alert-danger"><?= $error ?></div>
    <?php endif; ?>

    <form action="" method="POST" enctype="multipart/form-data" class="form-box">
        <div class="form-group">
            <label>Product Name</label>
            <input type="text" name="name" class="form-control" required>
        </div>

        <div class="form-group">
            <label>Category</label>
            <select name="category_id" class="form-control" required>
                <option value="">-- Select Category --</option>
                <?php foreach ($categories as $cat): ?>
                    <option value="<?= $cat['category_id'] ?>"><?= htmlspecialchars($cat['name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="form-group">
            <label>Base Price (KSh)</label>
            <input type="number" name="base_price" class="form-control" step="0.01" required>
        </div>

        <div class="form-group">
            <label>Stock Quantity</label>
            <input type="number" name="stock" class="form-control" required>
        </div>

        <div class="form-group">
            <label>Product Image</label>
            <input type="file" name="image" class="form-control" accept="image/*">
        </div>

        <div class="form-group">
            <label>Description</label>
            <textarea name="description" rows="4" class="form-control"></textarea>
        </div>

        <div class="form-group form-check">
            <input type="checkbox" name="is_active" class="form-check-input" checked>
            <label class="form-check-label">Active</label>
        </div>

        <button type="submit" class="btn btn-primary">Add Product</button>
        <a href="products.php" class="btn btn-secondary">Cancel</a>
    </form>
</div>

<?php require_once __DIR__ . '/includes/admin_footer.php'; ?>
