<?php
require_once '../includes/config.php';
require_once __DIR__ . '/includes/admin_auth.php';
require_once __DIR__ . '/includes/admin_header.php';

// Get filter parameters
$status = $_GET['status'] ?? '';
$search = $_GET['search'] ?? '';

// Build base query
$query = "
    SELECT o.order_id, o.order_date, o.total_amount, o.status, c.name AS customer_name 
    FROM orders o
    JOIN customers c ON o.customer_id = c.customer_id
    WHERE 1=1
";

$types = '';
$params = [];

if ($status) {
    $query .= " AND o.status = ?";
    $types .= 's';
    $params[] = $status;
}

if ($search) {
    $query .= " AND (c.name LIKE ? OR o.order_id LIKE ?)";
    $types .= 'ss';
    $params[] = "%$search%";
    $params[] = "%$search%";
}

$query .= " ORDER BY o.order_date DESC";

// Prepare and bind
$stmt = $conn->prepare($query);
if (!$stmt) {
    die("Database prepare failed: " . $conn->error);
}

if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();

$orders = [];
while ($row = $result->fetch_assoc()) {
    $orders[] = $row;
}
?>

<div class="admin-content">
    <div class="page-header">
        <h1 class="page-title">Orders</h1>
        <div class="page-actions">
            <a href="order_export.php" class="btn">
                <i class="fas fa-file-export"></i> Export
            </a>
        </div>
    </div>

    <div class="data-table-container">
        <div class="table-header">
            <h3 class="table-title">Order List</h3>
            <div class="table-actions">
                <form method="get" class="search-form">
                    <div class="search-box">
                        <i class="fas fa-search"></i>
                        <input type="text" name="search" placeholder="Search orders..." 
                               value="<?= htmlspecialchars($search) ?>">
                    </div>
                    <select name="status" class="form-control" onchange="this.form.submit()">
                        <option value="">All Statuses</option>
                        <option value="pending" <?= $status == 'pending' ? 'selected' : '' ?>>Pending</option>
                        <option value="processing" <?= $status == 'processing' ? 'selected' : '' ?>>Processing</option>
                        <option value="completed" <?= $status == 'completed' ? 'selected' : '' ?>>Completed</option>
                        <option value="cancelled" <?= $status == 'cancelled' ? 'selected' : '' ?>>Cancelled</option>
                    </select>
                </form>
            </div>
        </div>

        <table class="data-table">
            <thead>
                <tr>
                    <th>Order ID</th>
                    <th>Customer</th>
                    <th>Date</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($orders) > 0): ?>
                    <?php foreach ($orders as $order): ?>
                        <tr>
                            <td>#<?= htmlspecialchars($order['order_id']) ?></td>
                            <td><?= htmlspecialchars($order['customer_name']) ?></td>
                            <td><?= date('M j, Y', strtotime($order['order_date'])) ?></td>
                            <td>KSh <?= number_format($order['total_amount'], 2) ?></td>
                            <td>
                                <span class="status-badge <?= htmlspecialchars($order['status']) ?>">
                                    <?= ucfirst($order['status']) ?>
                                </span>
                            </td>
                            <td class="action-cell">
                                <a href="order_view.php?id=<?= $order['order_id'] ?>" class="action-btn" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="order_edit.php?id=<?= $order['order_id'] ?>" class="action-btn" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="order_invoice.php?id=<?= $order['order_id'] ?>" class="action-btn" title="Invoice" target="_blank">
                                    <i class="fas fa-file-invoice"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6">No orders found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <div class="table-footer">
            <div class="table-info">
                Showing <?= count($orders) ?> orders
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/includes/admin_footer.php'; ?>
