<?php
$pageTitle = 'About Us';
require_once __DIR__ . '/includes/header.php';
?>

<style>
.about-hero {
    background: url('<?php echo BASE_URL; ?>/images/roofing-bg.png') center center/cover no-repeat;
    color: white;
    padding: 100px 20px;
    text-align: center;
}
.about-hero h1 {
    font-size: 48px;
    margin-bottom: 10px;
}
.about-hero p {
    font-size: 20px;
    max-width: 700px;
    margin: 0 auto;
}
.about-section {
    padding: 60px 0;
}
.about-section h2 {
    font-size: 32px;
    margin-bottom: 20px;
}
.about-section p {
    font-size: 18px;
    line-height: 1.8;
    color: #444;
}
.features-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    gap: 30px;
    margin-top: 40px;
}
.feature {
    text-align: center;
    padding: 20px;
    background-color: #f8f9fa;
    border-radius: 12px;
    transition: 0.3s ease;
}
.feature:hover {
    background-color: #e6e6e6;
}
.feature i {
    font-size: 36px;
    color: #800080;
    margin-bottom: 15px;
}
.feature h3 {
    font-size: 20px;
    margin-bottom: 10px;
}
</style>

<main class="about-page">
    <section class="about-hero">
        <h1>Built to Last. Trusted Across Kenya.</h1>
        <p>At Reliable Mabati, we roof your dreams with durable, stylish, and affordable solutions—nationwide.</p>
    </section>

    <div class="container">
        <section class="about-section">
            <h2>Our Journey</h2>
            <p>What started in 2010 as a humble family-run shop is now a name trusted by thousands across Kenya. From Nairobi to Kisumu, our iron sheets protect homes, schools, and businesses with pride. Reliable Mabati is more than a brand—it’s a movement of builders, dreamers, and doers.</p>
        </section>

        <section class="about-section">
            <h2>Our Promise</h2>
            <p>We believe everyone deserves a roof they can rely on. That’s why we’ve built a reputation around quality, fairness, and exceptional service. We don’t just sell mabati—we deliver shelter, security, and style at a price you can afford.</p>
        </section>

        <section class="about-section">
            <h2>Why Choose Reliable Mabati?</h2>
            <div class="features-grid">
                <div class="feature">
                    <i class="fas fa-shield-alt"></i>
                    <h3>Certified Strength</h3>
                    <p>Our products are KEBS-approved and built for Kenya’s climate—from blazing sun to heavy rain.</p>
                </div>
                <div class="feature">
                    <i class="fas fa-truck-moving"></i>
                    <h3>Free Countrywide Delivery</h3>
                    <p>Whether you’re in Mombasa, Eldoret or the hills of Nyeri, your order gets to you fast—and free.</p>
                </div>
                <div class="feature">
                    <i class="fas fa-tags"></i>
                    <h3>Affordable for All</h3>
                    <p>Top quality doesn’t mean top price. Our rates are honest and our value unmatched.</p>
                </div>
                <div class="feature">
                    <i class="fas fa-user-headset"></i>
                    <h3>Real Human Support</h3>
                    <p>Got questions? Our friendly team is one call away—from planning to delivery.</p>
                </div>
            </div>
        </section>

        <section class="about-section">
            <h2>We’re Not Just Roofing. We’re Raising Standards.</h2>
            <p>Reliable Mabati is committed to raising the bar—better service, better sheets, better lives. Let's roof your future, together.</p>
        </section>
    </div>
</main>

<?php
require_once __DIR__ . '/includes/footer.php';
?>
