-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Aug 05, 2025 at 07:20 PM
-- Server version: 10.4.28-MariaDB
-- PHP Version: 8.2.4

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `mabati`
--

-- --------------------------------------------------------

--
-- Table structure for table `admin_permissions`
--

CREATE TABLE `admin_permissions` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `admin_permissions`
--

INSERT INTO `admin_permissions` (`id`, `name`, `description`, `created_at`) VALUES
(1, 'manage_users', 'Can create, edit and delete admin users', '2025-07-31 15:19:56'),
(2, 'manage_roles', 'Can manage roles and permissions', '2025-07-31 15:19:56'),
(3, 'manage_products', 'Can manage all products', '2025-07-31 15:19:56'),
(4, 'manage_categories', 'Can manage product categories', '2025-07-31 15:19:56'),
(5, 'manage_orders', 'Can view and process orders', '2025-07-31 15:19:56'),
(6, 'manage_customers', 'Can view and manage customers', '2025-07-31 15:19:56'),
(7, 'manage_content', 'Can manage website content and pages', '2025-07-31 15:19:56'),
(8, 'view_reports', 'Can view sales and analytics reports', '2025-07-31 15:19:56'),
(9, 'manage_settings', 'Can change system settings', '2025-07-31 15:19:56');

-- --------------------------------------------------------

--
-- Table structure for table `admin_roles`
--

CREATE TABLE `admin_roles` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `admin_roles`
--

INSERT INTO `admin_roles` (`id`, `name`, `description`, `created_at`) VALUES
(1, 'superadmin', 'Has full access to all features and settings', '2025-07-31 15:19:56'),
(2, 'admin', 'Can manage most content but not system settings', '2025-07-31 15:19:56'),
(3, 'editor', 'Can edit content but cannot manage users or settings', '2025-07-31 15:19:56'),
(4, 'sales', 'Can manage orders and customers only', '2025-07-31 15:19:56');

-- --------------------------------------------------------

--
-- Table structure for table `admin_role_permissions`
--

CREATE TABLE `admin_role_permissions` (
  `role_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `admin_role_permissions`
--

INSERT INTO `admin_role_permissions` (`role_id`, `permission_id`, `created_at`) VALUES
(1, 1, '2025-07-31 15:19:56'),
(1, 2, '2025-07-31 15:19:56'),
(1, 3, '2025-07-31 15:19:56'),
(1, 4, '2025-07-31 15:19:56'),
(1, 5, '2025-07-31 15:19:56'),
(1, 6, '2025-07-31 15:19:56'),
(1, 7, '2025-07-31 15:19:56'),
(1, 8, '2025-07-31 15:19:56'),
(1, 9, '2025-07-31 15:19:56'),
(2, 3, '2025-07-31 15:19:56'),
(2, 4, '2025-07-31 15:19:56'),
(2, 5, '2025-07-31 15:19:56'),
(2, 6, '2025-07-31 15:19:56'),
(2, 7, '2025-07-31 15:19:56'),
(2, 8, '2025-07-31 15:19:56'),
(3, 3, '2025-07-31 15:19:56'),
(3, 4, '2025-07-31 15:19:56'),
(3, 7, '2025-07-31 15:19:56'),
(4, 5, '2025-07-31 15:19:56'),
(4, 6, '2025-07-31 15:19:56'),
(4, 8, '2025-07-31 15:19:56');

-- --------------------------------------------------------

--
-- Table structure for table `admin_users`
--

CREATE TABLE `admin_users` (
  `id` int(11) NOT NULL,
  `username` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `full_name` varchar(100) DEFAULT NULL,
  `role_id` int(11) NOT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `last_login` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `phone` varchar(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `admin_users`
--

INSERT INTO `admin_users` (`id`, `username`, `email`, `password_hash`, `full_name`, `role_id`, `is_active`, `last_login`, `created_at`, `updated_at`, `phone`) VALUES
(1, 'superadmin', 'superadmin@reliablemabati.co.ke', '$2y$10$4WMZIFCRwPhDlwknf4U3peut.7j3zdv3e1P5TE/kaNDYseLLQ5.xG', 'System Superadmin', 1, 1, '2025-08-04 04:44:22', '2025-07-31 15:51:22', '2025-08-04 04:44:22', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `blog_posts`
--

CREATE TABLE `blog_posts` (
  `post_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `excerpt` text DEFAULT NULL,
  `slug` varchar(255) NOT NULL,
  `featured_image` varchar(255) DEFAULT NULL,
  `author_id` int(11) DEFAULT NULL,
  `published_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `is_published` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `blog_posts`
--

INSERT INTO `blog_posts` (`post_id`, `title`, `content`, `excerpt`, `slug`, `featured_image`, `author_id`, `published_at`, `is_published`, `created_at`) VALUES
(1, 'Top 5 Roofing Styles in Kenya', 'Explore the most popular roofing styles used in Kenyan homes including box profile, decra, roman tile, and more.', 'Explore popular roofing styles for Kenyan homes.', 'top-5-roofing-styles-in-kenya', 'roofing-styles.jpg', 1, '2025-07-31 20:09:05', 1, '2025-07-31 20:09:05'),
(2, 'How to Choose the Right Roofing Material', 'This guide walks you through the factors to consider when choosing the right roofing for your project.', 'Guide on choosing the best roofing material.', 'how-to-choose-roofing-material', 'choosing-roofing.jpg', 1, '2025-07-31 20:09:05', 1, '2025-07-31 20:09:05'),
(3, 'Benefits of Mabati Roofing', 'Mabati offers durability, cost-efficiency, and a variety of designs. Learn why more Kenyans are choosing mabati.', 'Why Mabati is the go-to roofing choice.', 'benefits-of-mabati-roofing', 'mabati-benefits.jpg', 1, '2025-07-31 20:09:05', 1, '2025-07-31 20:09:05');

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `category_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `slug` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` (`category_id`, `name`, `slug`) VALUES
(1, 'Roofing Sheets', 'roofing-sheets'),
(2, 'Roofing Accessories', 'roofing-accessories'),
(3, 'Fasteners & Hardware', 'fasteners-hardware');

-- --------------------------------------------------------

--
-- Table structure for table `customers`
--

CREATE TABLE `customers` (
  `customer_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `customers`
--

INSERT INTO `customers` (`customer_id`, `name`, `email`, `phone`, `address`, `created_at`) VALUES
(1, 'Augustine Asiuyi', 'asiuyi780@gmail.com', '0745988782', 'Nairobi', '2025-07-31 20:10:42'),
(2, 'John Doe', 'johndoe@gmail.com', '078967743', 'Nairobi', '2025-08-01 08:43:22'),
(3, 'Baya', 'baya@gmail.com', '0786536283', 'Nairobi', '2025-08-04 04:46:32');

-- --------------------------------------------------------

--
-- Table structure for table `orders`
--

CREATE TABLE `orders` (
  `order_id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `order_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `total_amount` decimal(10,2) NOT NULL,
  `status` enum('pending','processing','completed','cancelled') DEFAULT 'pending',
  `delivery_address` text DEFAULT NULL,
  `notes` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `orders`
--

INSERT INTO `orders` (`order_id`, `customer_id`, `order_date`, `total_amount`, `status`, `delivery_address`, `notes`) VALUES
(1, 1, '2025-07-31 20:10:42', 1000.00, 'pending', 'Nairobi', ''),
(2, 2, '2025-08-01 08:43:22', 7500000.00, 'pending', 'Nairobi', ''),
(3, 3, '2025-08-04 04:46:32', 60000.00, 'pending', 'Nairobi', '10 pieces');

-- --------------------------------------------------------

--
-- Table structure for table `order_items`
--

CREATE TABLE `order_items` (
  `item_id` int(11) NOT NULL,
  `order_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `quantity` int(11) NOT NULL,
  `price` decimal(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `order_items`
--

INSERT INTO `order_items` (`item_id`, `order_id`, `product_id`, `variant_id`, `quantity`, `price`) VALUES
(1, 1, 12, NULL, 100, 10.00),
(2, 2, 3, NULL, 100, 75000.00),
(3, 3, 10, NULL, 10, 6000.00);

-- --------------------------------------------------------

--
-- Table structure for table `products`
--

CREATE TABLE `products` (
  `product_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `base_price` decimal(10,2) NOT NULL,
  `category_id` int(11) DEFAULT NULL,
  `image_url` varchar(255) DEFAULT NULL,
  `is_featured` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `stock` int(11) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `products`
--

INSERT INTO `products` (`product_id`, `name`, `description`, `base_price`, `category_id`, `image_url`, `is_featured`, `created_at`, `stock`, `is_active`) VALUES
(1, 'Reliable box profile Gauge 30', 'Product Overview:\\\\r\\\\nOur Box Profile Roofing Sheets are high-quality, precision-engineered metal sheets designed to offer a strong, stylish, and weather-resistant roofing solution. Ideal for both residential and commercial applications, these sheets combine functionality with aesthetics, ensuring a long-lasting roofing option for a wide range of structures.\\\\r\\\\n\\\\r\\\\nKey Features:\\\\r\\\\n\\\\r\\\\n✅ High Strength & Durability – Made from galvanized or pre-painted steel for superior protection against rust and corrosion.\\\\r\\\\n\\\\r\\\\n✅ Weather-Resistant – Engineered to withstand harsh weather conditions including heavy rainfall, strong winds, and UV exposure.\\\\r\\\\n\\\\r\\\\n✅ Attractive Finish – Available in a variety of colors and finishes to suit any design preference.\\\\r\\\\n\\\\r\\\\n✅ Easy Installation – Lightweight and designed for fast, simple installation, reducing labor costs.\\\\r\\\\n\\\\r\\\\n✅ Low Maintenance – Minimal upkeep required, saving you time and money over the long term.\\\\r\\\\n\\\\r\\\\nSpecifications:\\\\r\\\\n\\\\r\\\\nMaterial: Galvanized Steel / Pre-painted Galvalume (PPGI/PPGL)\\\\r\\\\n\\\\r\\\\nProfile Type: Box Profile\\\\r\\\\n\\\\r\\\\nThickness Options: 0.25mm – 0.5mm\\\\r\\\\n\\\\r\\\\nLength: Customizable (1m to 12m)\\\\r\\\\n\\\\r\\\\nEffective Cover Width: ~850mm – 1015mm depending on the profile\\\\r\\\\n\\\\r\\\\nCoating: Zinc, Aluminum-Zinc, or Color Coating\\\\r\\\\n\\\\r\\\\nAvailable Colors: Red, Blue, Charcoal Grey, Green, Maroon, Black & more\\\\r\\\\n\\\\r\\\\nApplications:\\\\r\\\\n\\\\r\\\\nResidential Homes\\\\r\\\\n\\\\r\\\\nWarehouses & Industrial Buildings\\\\r\\\\n\\\\r\\\\nSchools, Churches & Institutions\\\\r\\\\n\\\\r\\\\nCarports, Sheds, and Farmhouses', 480.00, 1, '1753988913_Reliable box profile.jpeg', 1, '2025-07-31 19:08:33', 120, 1),
(2, 'Reliable Brick Tile Gauge 30 ', 'Give your walls a timeless, rustic charm with our Reliable Brick Tiles – expertly crafted to replicate the authentic look of traditional brickwork while offering the ease and durability of modern materials. Whether you\\\\\\\'re renovating, building anew, or adding a stylish finish to your space, these tiles bring warmth, texture, and character to any surface.\\\\r\\\\n\\\\r\\\\nKey Features:\\\\r\\\\n\\\\r\\\\n✅ Authentic Brick Look – Designed to closely resemble real bricks, adding a classic, stylish aesthetic to both interior and exterior walls.\\\\r\\\\n\\\\r\\\\n✅ Durable & Weatherproof – Made from high-quality clay or concrete, ensuring long-lasting performance in all weather conditions.\\\\r\\\\n\\\\r\\\\n✅ Lightweight & Easy to Install – Slim profile makes them perfect for DIY projects and professional installations alike.\\\\r\\\\n\\\\r\\\\n✅ Low Maintenance – Resistant to fading, chipping, and cracking with minimal upkeep required.\\\\r\\\\n\\\\r\\\\n✅ Versatile Use – Perfect for feature walls, backsplashes, fences, pillars, fireplaces, facades, and more.\\\\r\\\\n\\\\r\\\\nSpecifications:\\\\r\\\\n\\\\r\\\\nMaterial: Clay / Cement / Porcelain (depending on variant)\\\\r\\\\n\\\\r\\\\nSize: Standard sizes available (e.g., 215mm x 65mm x 20mm)\\\\r\\\\n\\\\r\\\\nFinish: Rustic, Smooth, Textured, or Weathered\\\\r\\\\n\\\\r\\\\nColors: Red Clay, Coffee Brown, Charcoal Black, Antique White, Rustic Orange, Custom Finishes\\\\r\\\\n\\\\r\\\\nInstallation: Cement adhesive or tile glue with optional grouting\\\\r\\\\n\\\\r\\\\nApplications:\\\\r\\\\n\\\\r\\\\nLiving Rooms & Indoor Feature Walls\\\\r\\\\n\\\\r\\\\nKitchens & Backsplashes\\\\r\\\\n\\\\r\\\\nOutdoor Facades & Garden Walls\\\\r\\\\n\\\\r\\\\nCommercial Spaces, Cafés & Retail Stores\\\\r\\\\n\\\\r\\\\nBoundary Walls, Columns & Chimneys', 620.00, 1, '1753989544_Reliable Brick tile.jpeg', 1, '2025-07-31 19:19:04', 50, 1),
(3, 'Reliable Corrugated Gauge 30', 'Classic wave-style roofing sheets that are economical, lightweight, and perfect for both industrial and rural projects.', 480.00, 1, '1753989583_Reliable Corrugated.jpeg', 1, '2025-07-31 19:19:43', 50, 1),
(4, 'Reliable Decra Tile Gauge 30', 'Stone-coated metal tiles offering premium aesthetics, insulation, and long-lasting protection against extreme weather.', 620.00, 1, '1753989620_Reliable Decra Tile.jpeg', 0, '2025-07-31 19:20:20', 55, 1),
(5, 'Reliable Roman Tile Gauge 30', 'Elegant and traditional Roman-style profile that mimics clay tiles with the strength of modern metal roofing.\\\\r\\\\n\\\\r\\\\n', 620.00, 1, '1753990025_Reliable Roman Tile.jpeg', 0, '2025-07-31 19:27:05', 70, 1),
(6, 'Reliable Zentile Gauge 30', 'Contemporary metal tile roofing with a sleek, low-profile design for a clean, modern architectural finish.', 620.00, 1, '1753990063_Reliable Zentile.jpeg', 0, '2025-07-31 19:27:43', 100, 1),
(7, 'Reliable Flat Ridge Caps Gauge 30', 'Seals and finishes the peak of your roof while providing ventilation and protecting against leaks.', 500.00, 2, '1753990106_Reliable Ridge caps.jpeg', 1, '2025-07-31 19:28:26', 120, 1),
(8, 'Reliable Roll Tops Gauge 30', 'Curved metal roll tops that enhance both the aesthetic and waterproofing of your roof ridges.', 650.00, 2, '1753990155_Reliable Roll tops.jpeg', 1, '2025-07-31 19:29:15', 200, 1),
(9, 'Ridge Caps Matte Finish Gauge 30', 'Matte-finish ridge caps for a stylish and non-glossy look that complements modern roofing styles.', 650.00, 2, '1753990186_Ridge Caps Matte Finish.jpeg', 1, '2025-07-31 19:29:46', 240, 1),
(10, 'Reliable Box Profile Valleys Gauge 30 ', 'Designed for box profile roofs, these valleys direct water efficiently and prevent water ingress at joints.\\\\r\\\\n\\\\r\\\\n', 480.00, 2, '1753990244_Reliable box profile valleys.jpeg', 0, '2025-07-31 19:30:44', 400, 1),
(11, 'Reliable Tiles Valleys Gauge 30', 'Specially shaped to direct water off tile roofs while preventing leaks along roof valleys.', 500.00, 2, '1753990278_Reliable Tiles valleys.jpeg', 0, '2025-07-31 19:31:18', 340, 1),
(12, 'Roofing Nails per Kg (/Kg)', 'Galvanized nails with umbrella heads for securely fixing roofing sheets. Designed for grip, weather resistance, and ease of use.', 250.00, 3, '1753990347_Roofing nails.jpeg', 1, '2025-07-31 19:32:27', 100000, 1),
(13, 'Concrete Steel Nails per Kg (/kg)', 'Heavy-duty nails suitable for fixing wood or metal to concrete. Tough, rust-resistant, and long-lasting.', 350.00, 3, '1753990376_Concrete steel nails.jpeg', 1, '2025-07-31 19:32:56', 100000, 1);

-- --------------------------------------------------------

--
-- Table structure for table `product_variants`
--

CREATE TABLE `product_variants` (
  `variant_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `variant_name` varchar(50) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `stock` int(11) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `quotes`
--

CREATE TABLE `quotes` (
  `quote_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `product_id` int(11) NOT NULL,
  `project_details` text NOT NULL,
  `date_submitted` datetime NOT NULL,
  `is_processed` tinyint(1) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `quotes`
--

INSERT INTO `quotes` (`quote_id`, `name`, `email`, `phone`, `product_id`, `project_details`, `date_submitted`, `is_processed`) VALUES
(1, 'Maweme Maiitn', 'nmjiu@gmail.com', '0798983644', 1, 'Trila', '2025-08-04 07:43:34', 0);

-- --------------------------------------------------------

--
-- Table structure for table `testimonials`
--

CREATE TABLE `testimonials` (
  `testimonial_id` int(11) NOT NULL,
  `customer_name` varchar(100) NOT NULL,
  `content` text NOT NULL,
  `rating` int(1) DEFAULT 5,
  `date_posted` timestamp NOT NULL DEFAULT current_timestamp(),
  `is_approved` tinyint(1) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `testimonials`
--

INSERT INTO `testimonials` (`testimonial_id`, `customer_name`, `content`, `rating`, `date_posted`, `is_approved`) VALUES
(1, 'Mary Njeri', 'I am very happy with the quality of roofing sheets!', 5, '2025-07-31 19:25:41', 1),
(2, 'Samuel Kiptoo', 'Fast delivery and good customer service.', 5, '2025-07-31 19:25:41', 1),
(3, 'Lucy Achieng', 'Reliable Mabati is truly reliable!', 5, '2025-07-31 19:25:41', 1);

--
-- Indexes for dumped tables
--

--
-- Indexes for table `admin_permissions`
--
ALTER TABLE `admin_permissions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `admin_roles`
--
ALTER TABLE `admin_roles`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `admin_role_permissions`
--
ALTER TABLE `admin_role_permissions`
  ADD PRIMARY KEY (`role_id`,`permission_id`),
  ADD KEY `permission_id` (`permission_id`);

--
-- Indexes for table `admin_users`
--
ALTER TABLE `admin_users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`),
  ADD UNIQUE KEY `email` (`email`),
  ADD KEY `role_id` (`role_id`);

--
-- Indexes for table `blog_posts`
--
ALTER TABLE `blog_posts`
  ADD PRIMARY KEY (`post_id`),
  ADD UNIQUE KEY `slug` (`slug`);

--
-- Indexes for table `categories`
--
ALTER TABLE `categories`
  ADD PRIMARY KEY (`category_id`),
  ADD UNIQUE KEY `slug` (`slug`);

--
-- Indexes for table `customers`
--
ALTER TABLE `customers`
  ADD PRIMARY KEY (`customer_id`),
  ADD UNIQUE KEY `email` (`email`);

--
-- Indexes for table `orders`
--
ALTER TABLE `orders`
  ADD PRIMARY KEY (`order_id`),
  ADD KEY `customer_id` (`customer_id`);

--
-- Indexes for table `order_items`
--
ALTER TABLE `order_items`
  ADD PRIMARY KEY (`item_id`),
  ADD KEY `order_id` (`order_id`),
  ADD KEY `product_id` (`product_id`),
  ADD KEY `variant_id` (`variant_id`);

--
-- Indexes for table `products`
--
ALTER TABLE `products`
  ADD PRIMARY KEY (`product_id`),
  ADD KEY `category_id` (`category_id`);

--
-- Indexes for table `product_variants`
--
ALTER TABLE `product_variants`
  ADD PRIMARY KEY (`variant_id`),
  ADD KEY `product_id` (`product_id`);

--
-- Indexes for table `quotes`
--
ALTER TABLE `quotes`
  ADD PRIMARY KEY (`quote_id`),
  ADD KEY `product_id` (`product_id`);

--
-- Indexes for table `testimonials`
--
ALTER TABLE `testimonials`
  ADD PRIMARY KEY (`testimonial_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `admin_permissions`
--
ALTER TABLE `admin_permissions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `admin_roles`
--
ALTER TABLE `admin_roles`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `admin_users`
--
ALTER TABLE `admin_users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `blog_posts`
--
ALTER TABLE `blog_posts`
  MODIFY `post_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `categories`
--
ALTER TABLE `categories`
  MODIFY `category_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `customers`
--
ALTER TABLE `customers`
  MODIFY `customer_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `orders`
--
ALTER TABLE `orders`
  MODIFY `order_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `order_items`
--
ALTER TABLE `order_items`
  MODIFY `item_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `products`
--
ALTER TABLE `products`
  MODIFY `product_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- AUTO_INCREMENT for table `product_variants`
--
ALTER TABLE `product_variants`
  MODIFY `variant_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `quotes`
--
ALTER TABLE `quotes`
  MODIFY `quote_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `testimonials`
--
ALTER TABLE `testimonials`
  MODIFY `testimonial_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `admin_role_permissions`
--
ALTER TABLE `admin_role_permissions`
  ADD CONSTRAINT `admin_role_permissions_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `admin_roles` (`id`),
  ADD CONSTRAINT `admin_role_permissions_ibfk_2` FOREIGN KEY (`permission_id`) REFERENCES `admin_permissions` (`id`);

--
-- Constraints for table `admin_users`
--
ALTER TABLE `admin_users`
  ADD CONSTRAINT `admin_users_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `admin_roles` (`id`);

--
-- Constraints for table `orders`
--
ALTER TABLE `orders`
  ADD CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`customer_id`);

--
-- Constraints for table `order_items`
--
ALTER TABLE `order_items`
  ADD CONSTRAINT `order_items_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`order_id`),
  ADD CONSTRAINT `order_items_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`),
  ADD CONSTRAINT `order_items_ibfk_3` FOREIGN KEY (`variant_id`) REFERENCES `product_variants` (`variant_id`);

--
-- Constraints for table `products`
--
ALTER TABLE `products`
  ADD CONSTRAINT `products_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `categories` (`category_id`);

--
-- Constraints for table `product_variants`
--
ALTER TABLE `product_variants`
  ADD CONSTRAINT `product_variants_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`);

--
-- Constraints for table `quotes`
--
ALTER TABLE `quotes`
  ADD CONSTRAINT `quotes_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
